/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.net.URISyntaxException;

public class AzureFindFeature
implements Find {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();
    private Cache<Path> cache;

    public AzureFindFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        AttributedList list;
        if (file.isRoot()) {
            return true;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            list = this.cache.get((Referenceable)file.getParent());
        } else {
            list = new AttributedList();
            this.cache.put((Referenceable)file.getParent(), list);
        }
        if (list.contains((Referenceable)file)) {
            return true;
        }
        if (this.cache.isHidden((Referenceable)file)) {
            return false;
        }
        try {
            try {
                boolean found;
                if (this.containerService.isContainer(file)) {
                    CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName());
                    found = container.exists(null, null, this.context);
                } else {
                    CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
                    found = blob.exists(null, null, this.context);
                }
                if (found) {
                    list.add((Referenceable)file);
                } else {
                    list.attributes().addHidden((Object)file);
                }
                return found;
            }
            catch (StorageException e) {
                throw new AzureExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

