/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Scheme;

public class AzureProtocol
extends AbstractProtocol {
    public String getName() {
        return "Azure";
    }

    public String getDefaultHostname() {
        return "<storageaccount>.blob.core.windows.net";
    }

    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString((String)"Storage Account Name", (String)"Azure");
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Primary Access Key", (String)"Azure");
    }

    public boolean isAnonymousConfigurable() {
        return false;
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public boolean isPortConfigurable() {
        return false;
    }

    public String getIdentifier() {
        return "azure";
    }

    public String getDescription() {
        return "Windows Azure Storage";
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public String[] getSchemes() {
        return new String[]{this.getScheme().name(), "azure"};
    }
}

