/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2StartLargeFileResponse;
import synapticloop.b2.util.URLEncoder;

public class B2StartLargeFileRequest
extends BaseB2Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2StartLargeFileRequest.class);
    private static final String B2_START_LARGE_FILE = "/b2api/v1/b2_start_large_file";
    protected static final String CONTENT_TYPE_VALUE_B2_X_AUTO = "b2/x-auto";

    public B2StartLargeFileRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId, String fileName, String mimeType, Map<String, String> fileInfo) throws B2ApiException {
        super(client, b2AuthorizeAccountResponse, b2AuthorizeAccountResponse.getApiUrl() + B2_START_LARGE_FILE);
        this.addProperty("bucketId", bucketId);
        this.addProperty("fileName", fileName);
        if (null == mimeType) {
            this.addProperty("contentType", CONTENT_TYPE_VALUE_B2_X_AUTO);
        } else {
            this.addProperty("contentType", mimeType);
        }
        if (null != fileInfo) {
            for (String key : fileInfo.keySet()) {
                this.addHeader("X-Bz-Info-" + URLEncoder.encode(key), URLEncoder.encode(fileInfo.get(key)));
            }
        }
    }

    public B2StartLargeFileResponse getResponse() throws B2ApiException, IOException {
        return new B2StartLargeFileResponse(EntityUtils.toString((HttpEntity)this.executePost().getEntity()));
    }
}

