/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.BucketType;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2DirectoryFeature
implements Directory<BaseB2Response> {
    protected static final String PLACEHOLDER = "/.bzEmpty";
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;
    private Write<BaseB2Response> writer;

    public B2DirectoryFeature(B2Session session) {
        this(session, new B2WriteFeature(session));
    }

    public B2DirectoryFeature(B2Session session, B2WriteFeature writer) {
        this.session = session;
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                B2BucketResponse response = ((B2ApiClient)this.session.getClient()).createBucket(this.containerService.getContainer(folder).getName(), null == region ? BucketType.valueOf((String)PreferencesFactory.get().getProperty("b2.bucket.acl.default")) : BucketType.valueOf((String)region));
                switch (response.getBucketType()) {
                    case allPublic: {
                        folder.attributes().setAcl(new Acl((Acl.User)new Acl.GroupUser("AllUsers", false), new Acl.Role[]{new Acl.Role("READ")}));
                    }
                }
                return folder;
            }
            if (Checksum.NONE == status.getChecksum()) {
                status.setChecksum(this.writer.checksum().compute((InputStream)new NullInputStream(0L), status.length(0L)));
            }
            status.setMime("application/octet-stream");
            StatusOutputStream out = this.writer.write(folder, status, (ConnectionCallback)new DisabledConnectionCallback());
            new DefaultStreamCloser().close((OutputStream)out);
            return new Path(folder.getParent(), folder.getName(), folder.getType(), new PathAttributesDictionary().deserialize(folder.attributes().serialize(SerializerFactory.get())).withVersionId(((B2FileResponse)out.getStatus()).getFileId()));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path workdir) {
        return true;
    }

    public B2DirectoryFeature withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }
}

