/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import ch.cyberduck.core.threading.CancelCallback;
import java.time.Duration;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;
import synapticloop.b2.exception.B2ApiException;

public class B2ExceptionMappingService
extends AbstractExceptionMappingService<B2ApiException> {
    private static final Logger log = Logger.getLogger(B2ExceptionMappingService.class);
    private final B2Session session;

    public B2ExceptionMappingService(B2Session session) {
        this.session = session;
    }

    public BackgroundException map(B2ApiException e) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        switch (e.getStatus()) {
            case 401: {
                if ("expired_auth_token".equalsIgnoreCase(e.getCode())) {
                    try {
                        this.session.login((HostPasswordStore)new DisabledPasswordStore(), (LoginCallback)new DisabledLoginCallback(), (CancelCallback)new DisabledCancelCallback(), (Cache<Path>)PathCache.empty());
                        return new RetriableAccessDeniedException(buffer.toString());
                    }
                    catch (BackgroundException f) {
                        log.warn((Object)String.format("Attempt to renew expired auth token failed. %s", f.getDetail()));
                    }
                }
            }
            case 403: {
                if ("cap_exceeded".equalsIgnoreCase(e.getCode()) || "storage_cap_exceeded".equalsIgnoreCase(e.getCode()) || "transaction_cap_exceeded".equalsIgnoreCase(e.getCode())) {
                    return new QuotaException(buffer.toString(), (Throwable)e);
                }
            }
            case 400: {
                if ("file_not_present".equalsIgnoreCase(e.getCode())) {
                    return new NotfoundException(buffer.toString(), (Throwable)e);
                }
                if ("bad_bucket_id".equalsIgnoreCase(e.getCode())) {
                    return new NotfoundException(buffer.toString(), (Throwable)e);
                }
                if ("cap_exceeded".equalsIgnoreCase(e.getCode())) {
                    return new QuotaException(buffer.toString(), (Throwable)e);
                }
                if ("too_many_buckets".equalsIgnoreCase(e.getCode())) {
                    return new QuotaException(buffer.toString(), (Throwable)e);
                }
                if (!"bad_request".equalsIgnoreCase(e.getCode()) || !"sha1 did not match data received".equalsIgnoreCase(e.getMessage())) break;
                return new ChecksumException(buffer.toString(), (Throwable)e);
            }
        }
        if (e.getRetry() != null) {
            return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(e.getRetry().intValue()), (Throwable)e);
        }
        return new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatus(), buffer.toString()));
    }
}

