/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class B2FileidProvider
implements IdProvider {
    private final B2Session session;
    private Cache<Path> cache = PathCache.empty();

    public B2FileidProvider(B2Session session) {
        this.session = session;
    }

    public String getFileid(Path file) throws BackgroundException {
        AttributedList<Path> list;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (!this.cache.isCached((Referenceable)file.getParent())) {
            list = this.session.list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
            this.cache.put((Referenceable)file.getParent(), list);
        } else {
            list = this.cache.get((Referenceable)file.getParent());
        }
        Path found = (Path)list.find((Predicate)new SimplePathPredicate(file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return found.attributes().getVersionId();
    }

    public IdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

