/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;

public class B2FindFeature
implements Find {
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;
    private Cache<Path> cache = PathCache.empty();

    public B2FindFeature(B2Session session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                List buckets = ((B2ApiClient)this.session.getClient()).listBuckets();
                for (B2BucketResponse bucket : buckets) {
                    if (!StringUtils.equals((CharSequence)this.containerService.getContainer(file).getName(), (CharSequence)bucket.getBucketName())) continue;
                    return true;
                }
            } else {
                try {
                    return null != new B2FileidProvider(this.session).withCache(this.cache).getFileid(file);
                }
                catch (NotfoundException e) {
                    return false;
                }
            }
            return false;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

