/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;
import synapticloop.b2.response.B2ListPartsResponse;
import synapticloop.b2.response.B2UploadPartResponse;

public class B2LargeUploadPartService {
    private static final Logger log = Logger.getLogger(B2LargeUploadPartService.class);
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;

    public B2LargeUploadPartService(B2Session session) {
        this.session = session;
    }

    public List<B2FileInfoResponse> find(Path file) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finding multipart uploads for %s", file));
        }
        try {
            B2ListFilesResponse chunk;
            ArrayList<B2FileInfoResponse> uploads = new ArrayList<B2FileInfoResponse>();
            String startFileId = null;
            do {
                chunk = ((B2ApiClient)this.session.getClient()).listUnfinishedLargeFiles(new B2FileidProvider(this.session).getFileid(this.containerService.getContainer(file)), startFileId, null);
                for (B2FileInfoResponse upload : chunk.getFiles()) {
                    if (file.isDirectory()) {
                        Path parent = new Path(this.containerService.getContainer(file), upload.getFileName(), EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.upload)).getParent();
                        if (!parent.equals((Object)file)) continue;
                        uploads.add(upload);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)upload.getFileName(), (CharSequence)this.containerService.getKey(file))) continue;
                    uploads.add(upload);
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)String.format("Found %d previous multipart uploads for %s", uploads.size(), file));
            } while ((startFileId = chunk.getNextFileId()) != null);
            if (log.isInfoEnabled()) {
                for (B2FileInfoResponse upload : uploads) {
                    log.info((Object)String.format("Found multipart upload %s for %s", upload, file));
                }
            }
            Collections.reverse(uploads);
            return uploads;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
        }
    }

    public List<B2UploadPartResponse> list(String fileid) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("List completed parts of file %s", fileid));
        }
        try {
            B2ListPartsResponse response;
            ArrayList<B2UploadPartResponse> completed = new ArrayList<B2UploadPartResponse>();
            Integer startPartNumber = null;
            do {
                response = ((B2ApiClient)this.session.getClient()).listParts(fileid, startPartNumber, null);
                completed.addAll(response.getFiles());
            } while ((startPartNumber = response.getNextPartNumber()) != null);
            return completed;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void delete(String id) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Delete multipart upload for fileid %s", id));
        }
        try {
            ((B2ApiClient)this.session.getClient()).cancelLargeFileUpload(id);
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

