/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2ObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(B2ObjectListService.class);
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;
    private final int chunksize;

    public B2ObjectListService(B2Session session) {
        this(session, PreferencesFactory.get().getInteger("b2.listing.chunksize"));
    }

    public B2ObjectListService(B2Session session, int chunksize) {
        this.session = session;
        this.chunksize = chunksize;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList objects = new AttributedList();
            Marker marker = this.containerService.isContainer(directory) ? new Marker(null, null) : new Marker(String.format("%s%s", this.containerService.getKey(directory), Character.valueOf('/')), null);
            HashMap<String, Integer> revisions = new HashMap<String, Integer>();
            do {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("List directory %s with marker %s", directory, marker));
                }
                B2ListFilesResponse response = ((B2ApiClient)this.session.getClient()).listFileVersions(new B2FileidProvider(this.session).getFileid(this.containerService.getContainer(directory)), marker.nextFilename, marker.nextFileId, Integer.valueOf(this.chunksize), this.containerService.isContainer(directory) ? null : String.format("%s%s", this.containerService.getKey(directory), String.valueOf('/')), String.valueOf('/'));
                marker = this.parse(directory, (AttributedList<Path>)objects, response, revisions);
                listener.chunk(directory, objects);
            } while (marker.hasNext());
            return objects;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected Marker parse(Path directory, AttributedList<Path> objects, B2ListFilesResponse response, Map<String, Integer> revisions) throws BackgroundException {
        for (B2FileInfoResponse file : response.getFiles()) {
            Integer revision;
            if (StringUtils.isBlank((CharSequence)file.getFileId())) {
                Path placeholder = new Path(directory, PathNormalizer.name((String)file.getFileName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder));
                objects.add((Referenceable)placeholder);
                continue;
            }
            PathAttributes attributes = this.parse(file);
            if (revisions.keySet().contains(file.getFileName())) {
                attributes.setDuplicate(true);
                revision = revisions.get(file.getFileName()) + 1;
            } else {
                revision = 1;
            }
            attributes.setSize(file.getSize());
            revisions.put(file.getFileName(), revision);
            attributes.setRevision((long)revision.intValue());
            objects.add((Referenceable)new Path(directory, PathNormalizer.name((String)file.getFileName()), EnumSet.of(AbstractPath.Type.file), attributes));
        }
        if (null == response.getNextFileName()) {
            return new Marker(response.getNextFileName(), response.getNextFileId());
        }
        return new Marker(response.getNextFileName(), response.getNextFileId());
    }

    protected PathAttributes parse(B2FileInfoResponse response) {
        PathAttributes attributes = new PathAttributes();
        attributes.setChecksum(Checksum.parse((String)StringUtils.removeStart((String)StringUtils.lowerCase((String)response.getContentSha1(), (Locale)Locale.ROOT), (String)"unverified:")));
        long timestamp = response.getUploadTimestamp();
        attributes.setCreationDate(timestamp);
        attributes.setModificationDate(timestamp);
        attributes.setVersionId(response.getFileId());
        switch (response.getAction()) {
            case hide: 
            case start: {
                attributes.setDuplicate(true);
                attributes.setSize(-1L);
            }
        }
        return attributes;
    }

    private static final class Marker {
        public final String nextFilename;
        public final String nextFileId;

        public Marker(String nextFilename, String nextFileId) {
            this.nextFilename = nextFilename;
            this.nextFileId = nextFileId;
        }

        public boolean hasNext() {
            return this.nextFilename != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Marker{");
            sb.append("nextFilename='").append(this.nextFilename).append('\'');
            sb.append(", nextFileId='").append(this.nextFileId).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

