/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2ReadFeature
implements Read {
    private final B2Session session;

    public B2ReadFeature(B2Session session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                return ((B2ApiClient)this.session.getClient()).downloadFileRangeByIdToStream(new B2FileidProvider(this.session).getFileid(file), range.getStart(), range.getEnd());
            }
            return ((B2ApiClient)this.session.getClient()).downloadFileByIdToStream(new B2FileidProvider(this.session).getFileid(file));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.session).map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) {
        return true;
    }
}

