/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2BucketListService;
import ch.cyberduck.core.b2.B2BucketTypeFeature;
import ch.cyberduck.core.b2.B2DeleteFeature;
import ch.cyberduck.core.b2.B2DirectoryFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2FindFeature;
import ch.cyberduck.core.b2.B2HomeFinderService;
import ch.cyberduck.core.b2.B2LargeUploadWriteFeature;
import ch.cyberduck.core.b2.B2LifecycleFeature;
import ch.cyberduck.core.b2.B2ObjectListService;
import ch.cyberduck.core.b2.B2ReadFeature;
import ch.cyberduck.core.b2.B2ThresholdUploadService;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.b2.B2UrlProvider;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import javax.net.SocketFactory;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2Session
extends HttpSession<B2ApiClient> {
    public B2Session(Host host) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
    }

    public B2Session(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public B2Session(Host host, X509TrustManager trust, X509KeyManager key, ProxyFinder proxyFinder) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key, proxyFinder);
    }

    public B2Session(Host host, X509TrustManager trust, X509KeyManager key, SocketFactory socketFactory) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key, socketFactory);
    }

    public B2ApiClient connect(HostKeyCallback key) throws BackgroundException {
        return new B2ApiClient(this.builder.build((TranscriptListener)this).build());
    }

    public void logout() throws BackgroundException {
        try {
            ((B2ApiClient)this.client).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return new B2BucketListService(this).list(directory, listener);
        }
        return new B2ObjectListService(this).list(directory, listener);
    }

    public void login(HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel, Cache<Path> cache) throws BackgroundException {
        try {
            ((B2ApiClient)this.client).authenticate(this.host.getCredentials().getUsername(), this.host.getCredentials().getPassword());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this).map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Touch.class) {
            return (T)new B2TouchFeature(this);
        }
        if (type == Read.class) {
            return (T)new B2ReadFeature(this);
        }
        if (type == Upload.class) {
            return (T)new B2ThresholdUploadService(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new B2LargeUploadWriteFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new B2WriteFeature(this));
        }
        if (type == Directory.class) {
            return (T)new B2DirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new B2DeleteFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new B2UrlProvider(this);
        }
        if (type == Find.class) {
            return (T)new B2FindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new B2AttributesFinderFeature(this);
        }
        if (type == Home.class) {
            return (T)((Object)new B2HomeFinderService(this));
        }
        if (type == AclPermission.class) {
            return (T)((Object)new B2BucketTypeFeature(this));
        }
        if (type == Location.class) {
            return (T)((Object)new B2BucketTypeFeature(this));
        }
        if (type == IdProvider.class) {
            return (T)new B2FileidProvider(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new B2AttributesFinderFeature(this);
        }
        if (type == Lifecycle.class) {
            return (T)new B2LifecycleFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

