/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2SingleUploadService
extends HttpUploadFeature<BaseB2Response, MessageDigest> {
    private static final Logger log = Logger.getLogger(B2SingleUploadService.class);
    private Write<BaseB2Response> writer;

    public B2SingleUploadService(Write<BaseB2Response> writer) {
        super(writer);
        this.writer = writer;
    }

    public BaseB2Response upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, StreamCancelation cancel, StreamProgress progress, ConnectionCallback callback) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum().compute(local.getInputStream(), status));
        }
        return (BaseB2Response)super.upload(file, local, throttle, listener, status, cancel, progress, callback);
    }

    protected InputStream decorate(InputStream in, MessageDigest digest) throws IOException {
        if (null == digest) {
            return super.decorate(in, null);
        }
        return new DigestInputStream(super.decorate(in, (Object)digest), digest);
    }

    protected MessageDigest digest() throws IOException {
        MessageDigest digest = null;
        if (PreferencesFactory.get().getBoolean("b2.upload.checksum.verify")) {
            try {
                digest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return digest;
    }

    protected void post(Path file, MessageDigest digest, BaseB2Response response) throws BackgroundException {
        this.verify(file, digest, Checksum.parse((String)StringUtils.removeStart((String)((B2FileResponse)response).getContentSha1(), (String)"unverified:")));
    }

    protected void verify(Path file, MessageDigest digest, Checksum checksum) throws ChecksumException {
        if (null == digest) {
            log.debug((Object)String.format("Digest verification disabled for file %s", file));
            return;
        }
        if (file.getType().contains(AbstractPath.Type.encrypted)) {
            log.warn((Object)String.format("Skip checksum verification for %s with client side encryption enabled", file));
            return;
        }
        String expected = Hex.encodeHexString((byte[])digest.digest());
        if (!checksum.equals((Object)Checksum.parse((String)expected))) {
            throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between {0} hash {1} of uploaded data and ETag {2} returned by the server", checksum.algorithm.toString(), expected, checksum.hash));
        }
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

