/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2UrlProvider
implements UrlProvider {
    private static final Logger log = Logger.getLogger(B2UrlProvider.class);
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;

    public B2UrlProvider(B2Session session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        if (file.isVolume()) {
            return DescriptiveUrlBag.empty();
        }
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.isFile()) {
            String download = String.format("%s/file/%s/%s", ((B2ApiClient)this.session.getClient()).getDownloadUrl(), URIEncoder.encode((String)this.containerService.getContainer(file).getName()), URIEncoder.encode((String)this.containerService.getKey(file)));
            list.add(new DescriptiveUrl(URI.create(download), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), Scheme.https.name().toUpperCase(Locale.ROOT))));
            try {
                int seconds = 604800;
                Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                expiry.add(13, 604800);
                String token = ((B2ApiClient)this.session.getClient()).getDownloadAuthorization(new B2FileidProvider(this.session).getFileid(this.containerService.getContainer(file)), "", Integer.valueOf(604800));
                list.add(new DescriptiveUrl(URI.create(String.format("%s?Authorization=%s", download, token)), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(expiry.getTimeInMillis()))));
            }
            catch (BackgroundException | IOException | B2ApiException e) {
                log.warn((Object)String.format("Failure getting download authorization token %s", e.getMessage()));
            }
        }
        return list;
    }
}

