/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2GetUploadPartUrlResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2WriteFeature
extends AbstractHttpWriteFeature<BaseB2Response>
implements Write<BaseB2Response> {
    private static final Logger log = Logger.getLogger(B2WriteFeature.class);
    private final PathContainerService containerService = new PathContainerService();
    private final B2Session session;
    private final Find finder;
    private final AttributesFinder attributes;
    private final ThreadLocal<B2GetUploadUrlResponse> urls = new ThreadLocal();

    public B2WriteFeature(B2Session session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public B2WriteFeature(B2Session session, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<BaseB2Response> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<BaseB2Response> command = new DelayedHttpEntityCallable<BaseB2Response>(){

            public BaseB2Response call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    B2GetUploadUrlResponse uploadUrl;
                    Checksum checksum = status.getChecksum();
                    if (status.isSegment()) {
                        B2GetUploadPartUrlResponse uploadUrl2 = ((B2ApiClient)B2WriteFeature.this.session.getClient()).getUploadPartUrl(new B2FileidProvider(B2WriteFeature.this.session).getFileid(file));
                        return ((B2ApiClient)B2WriteFeature.this.session.getClient()).uploadLargeFilePart(uploadUrl2, status.getPart().intValue(), (HttpEntity)entity, checksum.hash);
                    }
                    if (null == B2WriteFeature.this.urls.get()) {
                        uploadUrl = ((B2ApiClient)B2WriteFeature.this.session.getClient()).getUploadUrl(new B2FileidProvider(B2WriteFeature.this.session).getFileid(B2WriteFeature.this.containerService.getContainer(file)));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Obtained upload URL %s for file %s", uploadUrl, file));
                        }
                        B2WriteFeature.this.urls.set(uploadUrl);
                    } else {
                        uploadUrl = (B2GetUploadUrlResponse)B2WriteFeature.this.urls.get();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Use upload URL %s for file %s", uploadUrl, file));
                        }
                    }
                    try {
                        return ((B2ApiClient)B2WriteFeature.this.session.getClient()).uploadFile(uploadUrl, file.isDirectory() ? String.format("%s%s", B2WriteFeature.this.containerService.getKey(file), "/.bzEmpty") : B2WriteFeature.this.containerService.getKey(file), (HttpEntity)entity, Checksum.NONE == checksum ? "do_not_verify" : checksum.hash, status.getMime(), status.getMetadata());
                    }
                    catch (B2ApiException e) {
                        B2WriteFeature.this.urls.remove();
                        throw e;
                    }
                }
                catch (B2ApiException e) {
                    throw new B2ExceptionMappingService(B2WriteFeature.this.session).map("Upload {0} failed", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum() {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha1);
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }
}

