/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.bonjour;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.bonjour.LimitedRendezvousListener;
import ch.cyberduck.core.bonjour.Rendezvous;
import ch.cyberduck.core.bonjour.RendezvousListener;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractRendezvous
implements Rendezvous {
    private static final Logger log = Logger.getLogger(AbstractRendezvous.class);
    private static final String SERVICE_TYPE_SFTP = "_sftp-ssh._tcp.";
    private static final String SERVICE_TYPE_FTP = "_ftp._tcp.";
    private static final String SERVICE_TYPE_WEBDAV = "_webdav._tcp";
    private static final String SERVICE_TYPE_WEBDAV_TLS = "_webdavs._tcp";
    private final Map<String, Host> services = new ConcurrentHashMap<String, Host>();
    private final Set<RendezvousListener> listeners = Collections.synchronizedSet(new HashSet());
    private LimitedRendezvousListener notifier;

    public String[] getServiceTypes() {
        return new String[]{SERVICE_TYPE_SFTP, SERVICE_TYPE_FTP, SERVICE_TYPE_WEBDAV, SERVICE_TYPE_WEBDAV_TLS};
    }

    @Override
    public void init() {
        this.notifier = new LimitedRendezvousListener(this.listeners);
    }

    @Override
    public void quit() {
        this.notifier.quit();
    }

    @Override
    public void addListener(RendezvousListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RendezvousListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int numberOfServices() {
        return this.services.size();
    }

    @Override
    public Host getService(int index) {
        return this.services.values().toArray(new Host[this.services.size()])[index];
    }

    @Override
    public Iterator<Host> iterator() {
        return this.services.values().iterator();
    }

    @Override
    public String getDisplayedName(String identifier) {
        Host host = this.services.get(identifier);
        if (null == host) {
            return LocaleFactory.localizedString((String)"Unknown");
        }
        return BookmarkNameProvider.toString((Host)host);
    }

    protected void add(String fullname, String hostname, int port, String user, String password, String path) {
        Protocol protocol = this.getProtocol(fullname);
        if (null == protocol) {
            log.warn((Object)String.format("Unknown service type for %s", fullname));
            return;
        }
        Host host = new Host(protocol, hostname, port);
        host.getCredentials().setUsername(user);
        host.getCredentials().setPassword(password);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            host.setDefaultPath(PathNormalizer.normalize((String)path));
        }
        host.setComment(UserDateFormatterFactory.get().getLongFormat(new Date().getTime()));
        this.add(fullname, host);
    }

    protected Protocol getProtocol(String fullname) {
        if (fullname.contains(SERVICE_TYPE_SFTP)) {
            return new SFTPProtocol();
        }
        if (fullname.contains(SERVICE_TYPE_FTP)) {
            return new FTPProtocol();
        }
        if (fullname.contains(SERVICE_TYPE_WEBDAV)) {
            return new DAVProtocol();
        }
        if (fullname.contains(SERVICE_TYPE_WEBDAV_TLS)) {
            return new DAVSSLProtocol();
        }
        log.warn((Object)String.format("Cannot find service type in %s", fullname));
        return null;
    }

    protected void add(String fullname, Host host) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Add resolved host %s for full name %s", host, fullname));
        }
        if (null == this.services.put(fullname, host)) {
            this.notifier.serviceResolved(fullname, host);
        }
    }

    protected void remove(String identifier) {
        Host host;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Remove host with identifier %s", identifier));
        }
        if (null == (host = this.services.remove(identifier))) {
            return;
        }
        this.notifier.serviceLost(host);
    }
}

