/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.bonjour;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.bonjour.RendezvousListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.TimedSemaphore;
import org.apache.log4j.Logger;

public class LimitedRendezvousListener
implements RendezvousListener {
    private static final Logger log = Logger.getLogger(LimitedRendezvousListener.class);
    private final TimedSemaphore limit;
    private final Set<RendezvousListener> listeners;

    public LimitedRendezvousListener(Set<RendezvousListener> listeners) {
        this(new TimedSemaphore(1L, TimeUnit.MINUTES, PreferencesFactory.get().getInteger("rendezvous.notification.limit")), listeners);
    }

    public LimitedRendezvousListener(TimedSemaphore limit, Set<RendezvousListener> listeners) {
        this.limit = limit;
        this.listeners = listeners;
    }

    public void quit() {
        this.limit.shutdown();
    }

    @Override
    public void serviceResolved(String identifier, Host host) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Service resolved with identifier %s with %s", identifier, host));
        }
        if (PreferencesFactory.get().getBoolean("rendezvous.loopback.suppress")) {
            try {
                if (InetAddress.getByName(host.getHostname()).equals(InetAddress.getLocalHost())) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Suppressed Rendezvous notification for %s", host));
                    }
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (this.acquire()) {
            for (RendezvousListener listener : this.listeners) {
                listener.serviceResolved(identifier, host);
            }
        }
    }

    @Override
    public void serviceLost(Host servicename) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Service with name %s lost", servicename));
        }
        if (this.acquire()) {
            for (RendezvousListener listener : this.listeners) {
                listener.serviceLost(servicename);
            }
        }
    }

    private boolean acquire() {
        if (this.limit.getAvailablePermits() > 0) {
            try {
                this.limit.acquire();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Acquired lock for %s", this.limit));
                }
                return true;
            }
            catch (InterruptedException e) {
                log.warn((Object)String.format("Failure acquiring lock %s", e.getMessage()));
            }
        }
        return false;
    }
}

