/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.bonjour;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.bonjour.Rendezvous;
import ch.cyberduck.core.bonjour.RendezvousFactory;
import ch.cyberduck.core.bonjour.RendezvousListener;
import ch.cyberduck.core.text.NaturalOrderComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public final class RendezvousCollection
extends AbstractHostCollection
implements RendezvousListener {
    private static final long serialVersionUID = 6468881403370416829L;
    private static RendezvousCollection RENDEZVOUS_COLLECTION;
    private static final Object lock;
    private final Rendezvous rendezvous;
    private final Comparator<String> comparator = new NaturalOrderComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RendezvousCollection defaultCollection() {
        Object object = lock;
        synchronized (object) {
            if (null == RENDEZVOUS_COLLECTION) {
                RENDEZVOUS_COLLECTION = new RendezvousCollection();
            }
            return RENDEZVOUS_COLLECTION;
        }
    }

    private RendezvousCollection() {
        this(RendezvousFactory.instance());
    }

    public RendezvousCollection(Rendezvous rendezvous) {
        this.rendezvous = rendezvous;
        this.rendezvous.addListener(this);
        this.collectionLoaded();
    }

    @Override
    public void serviceResolved(String identifier, Host host) {
        this.collectionItemAdded(host);
    }

    @Override
    public void serviceLost(Host host) {
        this.collectionItemRemoved(host);
    }

    public String getName() {
        return LocaleFactory.localizedString((String)"Bonjour");
    }

    public Host get(int row) {
        return this.rendezvous.getService(row);
    }

    public int size() {
        return this.rendezvous.numberOfServices();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Host remove(int row) {
        return null;
    }

    public Object[] toArray() {
        Object[] content = new Host[this.size()];
        int i = 0;
        Iterator<Host> iterator = this.iterator();
        while (iterator.hasNext()) {
            Host host = iterator.next();
            content[i] = host;
        }
        return content;
    }

    public Iterator<Host> iterator() {
        return this.rendezvous.iterator();
    }

    public boolean allowsAdd() {
        return false;
    }

    public boolean allowsDelete() {
        return false;
    }

    public boolean allowsEdit() {
        return false;
    }

    protected synchronized void sort() {
        Collections.sort(this, new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return RendezvousCollection.this.comparator.compare(BookmarkNameProvider.toString((Host)o1), BookmarkNameProvider.toString((Host)o2));
            }
        });
    }

    static {
        lock = new Object();
    }
}

