/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Referenceable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.log4j.Logger;

public abstract class AbstractCache<T extends Referenceable>
implements Cache<T> {
    private static final Logger log = Logger.getLogger(AbstractCache.class);
    private final Map<T, AttributedList<T>> impl;
    private final Map<CacheReference, T> reverse;

    public AbstractCache(int size) {
        if (size == Integer.MAX_VALUE) {
            this.impl = Collections.synchronizedMap(new LinkedHashMap());
            this.reverse = Collections.synchronizedMap(new LinkedHashMap());
        } else if (size == 0) {
            this.impl = Collections.emptyMap();
            this.reverse = Collections.emptyMap();
        } else {
            this.impl = Collections.synchronizedMap(new LRUMap(size));
            this.reverse = Collections.synchronizedMap(new LinkedHashMap());
        }
    }

    protected abstract CacheReference key(T var1);

    @Override
    public T lookup(CacheReference reference) {
        Referenceable[] entries;
        Referenceable parent = (Referenceable)this.reverse.get(reference);
        AttributedList<T> list = this.impl.get(parent);
        if (null == list) {
            log.warn((Object)String.format("Lookup failed for %s in reverse cache", reference));
            return null;
        }
        for (Referenceable entry : entries = list.toArray()) {
            if (!this.key(entry).equals(reference)) continue;
            return (T)entry;
        }
        List<T> hidden = list.attributes().getHidden();
        for (Referenceable entry : hidden) {
            if (!this.key(entry).equals(reference)) continue;
            return (T)entry;
        }
        log.warn((Object)String.format("Lookup failed for %s in reverse cache", reference));
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Set<T> keySet() {
        return this.impl.keySet();
    }

    public boolean containsKey(T reference) {
        return this.impl.containsKey(reference);
    }

    @Override
    public AttributedList<T> remove(T reference) {
        AttributedList<T> removed = this.impl.remove(reference);
        if (null == removed) {
            return AttributedList.emptyList();
        }
        for (Referenceable r : removed) {
            this.reverse.remove(this.key(r));
        }
        return removed;
    }

    @Override
    public AttributedList<T> get(T reference) {
        AttributedList<T> children = this.impl.get(reference);
        if (null == children) {
            log.warn((Object)String.format("No cache for %s", reference));
            return AttributedList.emptyList();
        }
        return children;
    }

    @Override
    public AttributedList<T> put(T reference, AttributedList<T> children) {
        CacheReference key;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Caching %s", reference));
        }
        for (Referenceable f : children) {
            key = this.key(f);
            this.reverse.remove(key);
            this.reverse.put(key, reference);
        }
        for (Referenceable f : children.attributes().getHidden()) {
            key = this.key(f);
            this.reverse.remove(key);
            this.reverse.put(key, reference);
        }
        return this.impl.put(reference, children);
    }

    @Override
    public boolean isCached(T reference) {
        return this.containsKey(reference);
    }

    @Override
    public boolean isValid(T reference) {
        if (this.isCached(reference)) {
            return !this.get(reference).attributes().isInvalid();
        }
        return false;
    }

    @Override
    public void invalidate(T reference) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Invalidate %s", reference));
        }
        if (this.containsKey(reference)) {
            this.get(reference).attributes().setInvalid(true);
        } else {
            log.warn((Object)String.format("No cache for %s", reference));
        }
    }

    @Override
    public void clear() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Clearing cache %s", this.toString()));
        }
        this.impl.clear();
        this.reverse.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cache{");
        sb.append("size=").append(this.impl.size());
        sb.append('}');
        return sb.toString();
    }
}

