/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.HostWriterFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.core.serializer.Writer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AbstractFolderHostCollection
extends AbstractHostCollection {
    private static final Logger log = Logger.getLogger(AbstractFolderHostCollection.class);
    private static final long serialVersionUID = 6598370606581477494L;
    private final Writer<Host> writer = HostWriterFactory.get();
    private final Reader<Host> reader = HostReaderFactory.get();
    protected final Local folder;

    public AbstractFolderHostCollection(Local f) {
        this.folder = f;
    }

    @Override
    public String getName() {
        return LocaleFactory.localizedString(this.folder.getName());
    }

    public Local getFile(Host bookmark) {
        return LocalFactory.get(this.folder, String.format("%s.duck", bookmark.getUuid()));
    }

    public Local getFolder() {
        return this.folder;
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        this.save(bookmark);
        super.collectionItemAdded(bookmark);
    }

    @Override
    public void collectionItemChanged(Host bookmark) {
        this.save(bookmark);
        super.collectionItemChanged(bookmark);
    }

    @Override
    public void collectionItemRemoved(Host bookmark) {
        try {
            this.lock();
            Local file = this.getFile(bookmark);
            file.delete();
        }
        catch (AccessDeniedException e) {
            log.error((Object)String.format("Failure removing bookmark %s", e.getMessage()));
        }
        finally {
            this.unlock();
            super.collectionItemRemoved(bookmark);
        }
    }

    protected void save(Host bookmark) {
        if (this.isLocked()) {
            log.debug((Object)String.format("Skip saving bookmark %s while loading", bookmark));
        } else {
            this.lock();
            try {
                this.folder.mkdir();
                Local f = this.getFile(bookmark);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Save bookmark %s", f));
                }
                this.writer.write(bookmark, f);
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure saving item in collection %s", e.getMessage()));
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws AccessDeniedException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reloading %s", this.folder.getAbsolute()));
        }
        this.lock();
        try {
            this.folder.mkdir();
            AttributedList<Local> bookmarks = this.folder.list().filter(new Filter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return file.getName().endsWith(".duck");
                }

                @Override
                public Pattern toPattern() {
                    return Pattern.compile(".*\\.duck");
                }
            });
            for (Local next : bookmarks) {
                Host bookmark = this.reader.read(next);
                if (null == bookmark) continue;
                this.add(bookmark);
            }
            this.sort();
        }
        finally {
            this.unlock();
        }
        super.load();
    }

    @Override
    public void save() {
    }
}

