/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.util.EnumSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPath {
    public static final String HOME = "~";

    public abstract EnumSet<Type> getType();

    public abstract char getDelimiter();

    public boolean isRoot() {
        return this.getAbsolute().equals(String.valueOf(this.getDelimiter()));
    }

    public abstract String getAbsolute();

    public abstract String getName();

    public String getExtension() {
        String extension = FilenameUtils.getExtension((String)this.getName());
        if (StringUtils.isEmpty((CharSequence)extension)) {
            return null;
        }
        return extension;
    }

    public static enum Type {
        file{

            @Override
            public int legacy() {
                return 1;
            }
        }
        ,
        directory{

            @Override
            public int legacy() {
                return 2;
            }
        }
        ,
        symboliclink{

            @Override
            public int legacy() {
                return 4;
            }
        }
        ,
        volume{

            @Override
            public int legacy() {
                return 8;
            }
        }
        ,
        placeholder{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        upload{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        encrypted{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        decrypted{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        vault{

            @Override
            public int legacy() {
                return 0;
            }
        };


        public abstract int legacy();
    }
}

