/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProtocol
implements Protocol {
    @Override
    public String getProvider() {
        return this.getIdentifier();
    }

    @Override
    public String getName() {
        return this.getScheme().name().toUpperCase(Locale.ROOT);
    }

    @Override
    public String favicon() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String[] getSchemes() {
        return new String[]{this.getScheme().name()};
    }

    public String toString() {
        return this.getProvider();
    }

    @Override
    public String disk() {
        return String.format("%s.tiff", this.getIdentifier());
    }

    @Override
    public String icon() {
        return this.disk();
    }

    @Override
    public boolean isSecure() {
        return this.getScheme().isSecure();
    }

    @Override
    public boolean isHostnameConfigurable() {
        return StringUtils.isBlank((CharSequence)this.getDefaultHostname());
    }

    @Override
    public boolean isPortConfigurable() {
        return StringUtils.isBlank((CharSequence)this.getDefaultHostname());
    }

    @Override
    public boolean isEncodingConfigurable() {
        return false;
    }

    @Override
    public boolean isAnonymousConfigurable() {
        return true;
    }

    @Override
    public boolean isUsernameConfigurable() {
        return true;
    }

    @Override
    public boolean isPasswordConfigurable() {
        return true;
    }

    @Override
    public boolean isUTCTimezone() {
        return true;
    }

    @Override
    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString("Username", "Credentials");
    }

    @Override
    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString("Password", "Credentials");
    }

    @Override
    public String getClientId() {
        return null;
    }

    @Override
    public String getClientSecret() {
        return null;
    }

    @Override
    public String getDefaultHostname() {
        return PreferencesFactory.get().getProperty("connection.hostname.default");
    }

    @Override
    public Set<Location.Name> getRegions() {
        return Collections.emptySet();
    }

    @Override
    public int getDefaultPort() {
        return this.getScheme().getPort();
    }

    @Override
    public String getContext() {
        return null;
    }

    @Override
    public String getAuthorization() {
        return null;
    }

    @Override
    public String getOAuthAuthorizationUrl() {
        return null;
    }

    @Override
    public String getOAuthTokenUrl() {
        return null;
    }

    @Override
    public List<String> getScopes() {
        return Collections.emptyList();
    }

    @Override
    public String getRegion() {
        return null;
    }

    @Override
    public Protocol.Type getType() {
        return Protocol.Type.valueOf(this.getIdentifier());
    }

    @Override
    public String getPrefix() {
        return String.format("%s.%s", this.getClass().getPackage().getName(), StringUtils.capitalize((String)this.getType().name()));
    }

    @Override
    public boolean validate(Credentials credentials, LoginOptions options) {
        return this.getType().validate(credentials, options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(protocol.getIdentifier()) : protocol.getIdentifier() != null) {
            return false;
        }
        if (this.getScheme() != null ? !this.getScheme().equals((Object)protocol.getScheme()) : protocol.getScheme() != null) {
            return false;
        }
        return !(this.getProvider() != null ? !this.getProvider().equals(protocol.getProvider()) : protocol.getProvider() != null);
    }

    @Override
    public int compareTo(Protocol o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        result = 31 * result + (this.getProvider() != null ? this.getProvider().hashCode() : 0);
        return result;
    }
}

