/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class AlertCallbackFactory
extends Factory<AlertCallback> {
    private static final Logger log = Logger.getLogger(AlertCallbackFactory.class);

    protected AlertCallbackFactory() {
        super("factory.alertcallback.class");
    }

    public AlertCallback create(Controller controller) {
        String clazz = PreferencesFactory.get().getProperty("factory.alertcallback.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (AlertCallback)name.newInstance();
            }
            return (AlertCallback)constructor.newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledAlertCallback();
        }
    }

    public static AlertCallback get(Controller c) {
        return new AlertCallbackFactory().create(c);
    }
}

