/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class BookmarkCollection
extends AbstractHostCollection {
    private static final Logger log = Logger.getLogger(BookmarkCollection.class);
    private static final long serialVersionUID = -74831755267110254L;
    private static final BookmarkCollection DEFAULT_COLLECTION = new BookmarkCollection(LocalFactory.get(PreferencesFactory.get().getProperty("application.support.path"), "Favorites.plist"));
    private final Local file;

    public static BookmarkCollection defaultCollection() {
        return DEFAULT_COLLECTION;
    }

    @Override
    public String getName() {
        return LocaleFactory.localizedString("Favorites");
    }

    public BookmarkCollection(Local file) {
        this.file = file;
    }

    @Override
    public boolean allowsAdd() {
        return FolderBookmarkCollection.favoritesCollection().allowsAdd();
    }

    @Override
    public boolean allowsDelete() {
        return FolderBookmarkCollection.favoritesCollection().allowsDelete();
    }

    @Override
    public boolean allowsEdit() {
        return FolderBookmarkCollection.favoritesCollection().allowsEdit();
    }

    @Override
    public Host lookup(String uuid) {
        return FolderBookmarkCollection.favoritesCollection().lookup(uuid);
    }

    @Override
    public int size() {
        return FolderBookmarkCollection.favoritesCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return FolderBookmarkCollection.favoritesCollection().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return FolderBookmarkCollection.favoritesCollection().contains(o);
    }

    @Override
    public Host get(int row) {
        return (Host)FolderBookmarkCollection.favoritesCollection().get(row);
    }

    @Override
    public boolean addAll(Collection<? extends Host> hosts) {
        return FolderBookmarkCollection.favoritesCollection().addAll(hosts);
    }

    @Override
    public boolean add(Host host) {
        return FolderBookmarkCollection.favoritesCollection().add(host);
    }

    @Override
    public void add(int row, Host host) {
        FolderBookmarkCollection.favoritesCollection().add(row, host);
    }

    @Override
    public Host remove(int row) {
        return (Host)FolderBookmarkCollection.favoritesCollection().remove(row);
    }

    @Override
    public boolean remove(Object host) {
        return FolderBookmarkCollection.favoritesCollection().remove(host);
    }

    @Override
    protected void sort() {
        FolderBookmarkCollection.favoritesCollection().sort();
    }

    @Override
    public int indexOf(Object elem) {
        return FolderBookmarkCollection.favoritesCollection().indexOf(elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        return FolderBookmarkCollection.favoritesCollection().lastIndexOf(elem);
    }

    @Override
    public void addListener(CollectionListener<Host> l) {
        FolderBookmarkCollection.favoritesCollection().addListener(l);
    }

    @Override
    public void removeListener(CollectionListener<Host> l) {
        FolderBookmarkCollection.favoritesCollection().removeListener(l);
    }

    @Override
    public void clear() {
        FolderBookmarkCollection.favoritesCollection().clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return FolderBookmarkCollection.favoritesCollection().removeAll(c);
    }

    @Override
    public void collectionItemChanged(Host item) {
        FolderBookmarkCollection.favoritesCollection().collectionItemChanged(item);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Host> c) {
        return FolderBookmarkCollection.favoritesCollection().addAll(index, c);
    }

    @Override
    public Iterator<Host> iterator() {
        return FolderBookmarkCollection.favoritesCollection().iterator();
    }

    @Override
    public ListIterator<Host> listIterator() {
        return FolderBookmarkCollection.favoritesCollection().listIterator();
    }

    @Override
    public ListIterator<Host> listIterator(int index) {
        return FolderBookmarkCollection.favoritesCollection().listIterator(index);
    }

    @Override
    public List<Host> subList(int fromIndex, int toIndex) {
        return FolderBookmarkCollection.favoritesCollection().subList(fromIndex, toIndex);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return FolderBookmarkCollection.favoritesCollection().containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return FolderBookmarkCollection.favoritesCollection().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return FolderBookmarkCollection.favoritesCollection().toArray(a);
    }

    @Override
    public void save() {
        if (this.isLocked()) {
            log.debug((Object)"Do not write locked collection");
            return;
        }
        FolderBookmarkCollection.favoritesCollection().save();
    }

    @Override
    public void load() throws AccessDeniedException {
        this.lock();
        try {
            FolderBookmarkCollection favorites = FolderBookmarkCollection.favoritesCollection();
            if (this.file.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Found Bookmarks file %s", this.file.getAbsolute()));
                }
                favorites.load(HostReaderFactory.get().readCollection(this.file));
                if (log.isInfoEnabled()) {
                    log.info((Object)"Moving deprecated bookmarks file to Trash");
                }
                try {
                    LocalTrashFactory.get().trash(this.file);
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)String.format("Failure trashing bookmark %s %s", this.file, e.getMessage()));
                }
            } else {
                favorites.load();
            }
        }
        finally {
            this.unlock();
        }
        super.load();
    }
}

