/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import org.apache.commons.lang3.StringUtils;

public final class BookmarkNameProvider {
    private BookmarkNameProvider() {
    }

    public static String toString(Host bookmark) {
        return BookmarkNameProvider.toString(bookmark, false);
    }

    public static String toString(Host bookmark, boolean username) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getNickname())) {
            if (StringUtils.equals((CharSequence)bookmark.getHostname(), (CharSequence)bookmark.getProtocol().getDefaultHostname())) {
                return bookmark.getProtocol().getName();
            }
            if (StringUtils.isBlank((CharSequence)bookmark.getHostname())) {
                return bookmark.getProtocol().getName();
            }
            if (username && !bookmark.getCredentials().isAnonymousLogin() && StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
                return String.format("%s@%s \u2013 %s", bookmark.getCredentials().getUsername(), StringUtils.strip((String)bookmark.getHostname()), bookmark.getProtocol().getName());
            }
            return String.format("%s \u2013 %s", StringUtils.strip((String)bookmark.getHostname()), bookmark.getProtocol().getName());
        }
        return bookmark.getNickname();
    }
}

