/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class CertificateStoreFactory
extends Factory<CertificateStore> {
    private static final Logger log = Logger.getLogger(CertificateStoreFactory.class);

    protected CertificateStoreFactory() {
        super("factory.certificatestore.class");
    }

    public CertificateStore create(Controller c) {
        String clazz = PreferencesFactory.get().getProperty("factory.certificatestore.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{c.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", c.getClass()));
                return (CertificateStore)name.newInstance();
            }
            return (CertificateStore)constructor.newInstance(c);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static CertificateStore get() {
        return (CertificateStore)new CertificateStoreFactory().create();
    }

    public static CertificateStore get(Controller c) {
        return new CertificateStoreFactory().create(c);
    }
}

