/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.exception.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class Collection<E>
extends ArrayList<E>
implements CollectionListener<E> {
    private static final Logger log = Logger.getLogger(Collection.class);
    private static final long serialVersionUID = 2169368029038925573L;
    private final ReentrantLock locked = new ReentrantLock();
    private final Set<CollectionListener<E>> listeners = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean loaded = new AtomicBoolean();

    public Collection() {
    }

    public Collection(java.util.Collection<E> c) {
        super(c);
    }

    public void load() throws AccessDeniedException {
        this.collectionLoaded();
    }

    @Override
    public int indexOf(Object elem) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(elem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(elem)) continue;
            return i;
        }
        return -1;
    }

    public void addListener(CollectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean addAll(java.util.Collection<? extends E> es) {
        super.addAll(es);
        for (E item : es) {
            this.collectionItemAdded(item);
        }
        return true;
    }

    @Override
    public boolean add(E object) {
        super.add(object);
        this.collectionItemAdded(object);
        return true;
    }

    @Override
    public void add(int row, E object) {
        super.add(row, object);
        this.collectionItemAdded(object);
    }

    @Override
    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public E remove(int row) {
        Object previous = super.remove(row);
        this.collectionItemRemoved((E)previous);
        return previous;
    }

    @Override
    public boolean remove(Object item) {
        boolean previous = super.remove(item);
        this.collectionItemRemoved((E)item);
        return previous;
    }

    @Override
    public boolean removeAll(java.util.Collection<?> c) {
        boolean modified = false;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            Object item = e.next();
            if (!c.contains(item)) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void collectionLoaded() {
        this.loaded.set(true);
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionLoaded();
        }
    }

    @Override
    public void collectionItemAdded(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemAdded(item);
        }
    }

    @Override
    public void collectionItemRemoved(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemRemoved(item);
        }
    }

    @Override
    public void collectionItemChanged(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener listener : this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            listener.collectionItemChanged(item);
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public boolean isLocked() {
        return this.locked.isLocked();
    }

    protected void lock() {
        this.locked.lock();
    }

    protected void unlock() {
        this.locked.unlock();
    }
}

