/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.sftp.openssh.OpenSSHCredentialsConfigurator;

public final class CredentialsConfiguratorFactory {
    private static CredentialsConfigurator instance;
    private static final Object lock;

    private CredentialsConfiguratorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialsConfigurator get(Protocol protocol) {
        if (protocol.getType() == Protocol.Type.sftp) {
            Object object = lock;
            synchronized (object) {
                if (null == instance) {
                    instance = new OpenSSHCredentialsConfigurator();
                } else {
                    instance.reload();
                }
                return instance;
            }
        }
        return new NullCredentialsConfigurator();
    }

    static {
        lock = new Object();
    }

    private static final class NullCredentialsConfigurator
    implements CredentialsConfigurator {
        private NullCredentialsConfigurator() {
        }

        @Override
        public Credentials configure(Host host) {
            return host.getCredentials();
        }

        @Override
        public void reload() {
        }
    }
}

