/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class DefaultPathPredicate
implements CacheReference<Path> {
    private final Path file;
    private final PathContainerService containerService = new PathContainerService();

    public DefaultPathPredicate(Path file) {
        this.file = file;
    }

    public String attributes() {
        String qualifier = "";
        if (StringUtils.isNotBlank((CharSequence)this.file.attributes().getRegion()) && this.containerService.isContainer(this.file)) {
            qualifier = qualifier + this.file.attributes().getRegion();
        }
        if (StringUtils.isNotBlank((CharSequence)this.file.attributes().getVersionId())) {
            qualifier = qualifier + this.file.attributes().getVersionId();
        }
        return qualifier;
    }

    protected String type() {
        EnumSet<AbstractPath.Type> types = EnumSet.copyOf(this.file.getType());
        types.remove((Object)AbstractPath.Type.placeholder);
        types.remove((Object)AbstractPath.Type.volume);
        types.remove((Object)AbstractPath.Type.encrypted);
        types.remove((Object)AbstractPath.Type.decrypted);
        types.remove((Object)AbstractPath.Type.vault);
        return String.valueOf(types);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.type() + "-" + this.attributes() + this.file.getAbsolute();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof CacheReference) {
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    @Override
    public boolean test(Path file) {
        return this.hashCode() == new DefaultPathPredicate(file).hashCode();
    }
}

