/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Deserializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class DeserializerFactory<T>
extends Factory<Deserializer> {
    private static final Preferences preferences = PreferencesFactory.get();
    private final String clazz;

    public DeserializerFactory() {
        this.clazz = preferences.getProperty("factory.deserializer.class");
    }

    public DeserializerFactory(String clazz) {
        this.clazz = clazz;
    }

    public Deserializer create(T dict) {
        if (null == this.clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(this.clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{dict.getClass()});
            return (Deserializer)constructor.newInstance(dict);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static <T> Deserializer get(T dict) {
        return new DeserializerFactory<T>().create(dict);
    }
}

