/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;

public final class HostCredentials
extends Credentials {
    private final Host host;

    public HostCredentials(Host host) {
        super(PreferencesFactory.get().getProperty("connection.login.name"));
        this.host = host;
    }

    public HostCredentials(Host host, String user) {
        super(user);
        this.host = host;
    }

    public HostCredentials(Host host, String user, String password) {
        super(user, password);
        this.host = host;
    }

    @Override
    public String getUsernamePlaceholder() {
        return this.host.getProtocol().getUsernamePlaceholder();
    }

    @Override
    public String getPasswordPlaceholder() {
        if (this.isPublicKeyAuthentication()) {
            return LocaleFactory.localizedString("Private Key Passphrase", "Credentials");
        }
        return this.host.getProtocol().getPasswordPlaceholder();
    }
}

