/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class HostKeyCallbackFactory
extends Factory<HostKeyCallback> {
    private static final Logger log = Logger.getLogger(HostKeyCallbackFactory.class);

    protected HostKeyCallbackFactory() {
        super("factory.hostkeycallback.class");
    }

    public HostKeyCallback create(Controller c, Protocol protocol) {
        if (Scheme.sftp.equals((Object)protocol.getScheme())) {
            String clazz = PreferencesFactory.get().getProperty("factory.hostkeycallback.class");
            if (null == clazz) {
                throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
            }
            try {
                Class<?> name = Class.forName(clazz);
                Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{c.getClass()});
                if (null == constructor) {
                    log.warn((Object)String.format("No matching constructor for parameter %s", c.getClass()));
                    return (HostKeyCallback)name.newInstance();
                }
                return (HostKeyCallback)constructor.newInstance(c);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
                return new DisabledHostKeyCallback();
            }
        }
        return new DisabledHostKeyCallback();
    }

    public static HostKeyCallback get(Controller c, Protocol protocol) {
        return new HostKeyCallbackFactory().create(c, protocol);
    }
}

