/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordStore;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class HostPasswordStore
implements PasswordStore {
    private static final Logger log = Logger.getLogger(HostPasswordStore.class);

    public String find(Host host) {
        String p;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching password from keychain for %s", host));
        }
        if (StringUtils.isEmpty((CharSequence)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = host.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (credentials.isPublicKeyAuthentication()) {
            Local key = credentials.getIdentity();
            p = this.getPassword(host.getHostname(), key.getAbbreviatedPath());
            if (null == p) {
                p = this.getPassword("SSH", key.getAbsolute());
            }
            if (null == p) {
                p = this.getPassword("SSHKeychain", key.getAbbreviatedPath());
            }
        } else {
            p = this.getPassword(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), credentials.getUsername());
        }
        if (null == p && log.isInfoEnabled()) {
            log.info((Object)String.format("Password not found in keychain for %s", host));
        }
        return p;
    }

    public void save(Host host) {
        if (StringUtils.isEmpty((CharSequence)host.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        Credentials credentials = host.getCredentials();
        if (!credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip writing credentials for host %s", host.getHostname()));
            }
            return;
        }
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)String.format("No username in credentials for host %s", host.getHostname()));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)credentials.getPassword())) {
            log.warn((Object)String.format("No password in credentials for host %s", host.getHostname()));
            return;
        }
        if (credentials.isAnonymousLogin()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Do not write anonymous credentials for host %s", host.getHostname()));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Add password for host %s", host));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(host.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
        } else {
            this.addPassword(host.getProtocol().getScheme(), host.getPort(), host.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
    }
}

