/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.idna.PunycodeConverter;
import org.apache.commons.lang3.StringUtils;

public class HostUrlProvider {
    private final boolean username;
    private final boolean path;

    public HostUrlProvider() {
        this(true, false);
    }

    public HostUrlProvider(boolean username) {
        this(username, false);
    }

    public HostUrlProvider(boolean username, boolean path) {
        this.username = username;
        this.path = path;
    }

    public String get(Host host) {
        String base = String.format("%s://%s%s%s", host.getProtocol().getScheme().toString(), this.username && StringUtils.isNotEmpty((CharSequence)host.getCredentials().getUsername()) ? String.format("%s@", host.getCredentials().getUsername()) : "", new PunycodeConverter().convert(host.getHostname()), host.getPort() != host.getProtocol().getScheme().getPort() ? String.format(":%d", host.getPort()) : "");
        if (this.path && StringUtils.isNotBlank((CharSequence)host.getDefaultPath())) {
            return String.format("%s%s", base, PathNormalizer.normalize(host.getDefaultPath()));
        }
        return base;
    }
}

