/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostnameConfigurator;

public final class HostnameConfiguratorFactory {
    private static HostnameConfigurator instance;
    private static final Object lock;

    private HostnameConfiguratorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostnameConfigurator get(Protocol protocol) {
        if (protocol.getType() == Protocol.Type.sftp) {
            Object object = lock;
            synchronized (object) {
                if (null == instance) {
                    instance = new OpenSSHHostnameConfigurator();
                } else {
                    instance.reload();
                }
                return instance;
            }
        }
        return new NullHostnameConfigurator();
    }

    static {
        lock = new Object();
    }

    private static final class NullHostnameConfigurator
    implements HostnameConfigurator {
        private NullHostnameConfigurator() {
        }

        @Override
        public String getHostname(String alias) {
            return alias;
        }

        @Override
        public int getPort(String alias) {
            return -1;
        }

        @Override
        public void reload() {
        }
    }
}

