/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.Checksum;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import org.apache.log4j.Logger;

public class LocalAttributes
extends Attributes {
    private static final Logger log = Logger.getLogger(LocalAttributes.class);
    private final String path;
    private Checksum checksum = Checksum.NONE;
    private Permission permission = Permission.EMPTY;

    public LocalAttributes(String path) {
        this.path = path;
        this.permission = new LocalPermission();
    }

    @Override
    public long getModificationDate() {
        if (Files.exists(Paths.get(this.path, new String[0]), new LinkOption[0])) {
            try {
                return Files.getLastModifiedTime(Paths.get(this.path, new String[0]), new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure getting timestamp of %s. %s", this.path, e.getMessage()));
            }
        }
        return -1L;
    }

    @Override
    public long getCreationDate() {
        return this.getModificationDate();
    }

    @Override
    public long getAccessedDate() {
        return this.getModificationDate();
    }

    public void setModificationDate(long timestamp) throws AccessDeniedException {
        if (timestamp < 0L) {
            return;
        }
        try {
            Files.setLastModifiedTime(Paths.get(this.path, new String[0]), FileTime.fromMillis(timestamp));
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(String.format("Cannot change timestamp for %s", this.path), e);
        }
    }

    @Override
    public long getSize() {
        if (Files.exists(Paths.get(this.path, new String[0]), new LinkOption[0])) {
            try {
                return Files.size(Paths.get(this.path, new String[0]));
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure getting size of %s. %s", this.path, e.getMessage()));
            }
        }
        return -1L;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) throws AccessDeniedException {
        this.permission = permission;
    }

    public boolean isBundle() {
        return false;
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LocalAttributes{");
        sb.append("checksum='").append(this.checksum).append('\'');
        sb.append(", timestamp=").append(this.getModificationDate());
        sb.append(", permission=").append(this.permission);
        sb.append('}');
        return sb.toString();
    }

    protected class LocalPermission
    extends Permission {
        public LocalPermission() {
        }

        public LocalPermission(String mode) {
            super(mode);
        }

        public LocalPermission(int mode) {
            super(mode);
        }

        @Override
        public boolean isReadable() {
            return Files.isReadable(Paths.get(LocalAttributes.this.path, new String[0]));
        }

        @Override
        public boolean isWritable() {
            return Files.isWritable(Paths.get(LocalAttributes.this.path, new String[0]));
        }

        @Override
        public boolean isExecutable() {
            return Files.isExecutable(Paths.get(LocalAttributes.this.path, new String[0]));
        }
    }
}

