/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public final class LocalFactory
extends Factory<Local> {
    protected LocalFactory() {
        super("factory.local.class");
    }

    @Override
    protected Local create() {
        return this.create(PreferencesFactory.get().getProperty("local.user.home"));
    }

    protected Local create(String path) {
        String clazz = PreferencesFactory.get().getProperty("factory.local.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{path.getClass()});
            return (Local)constructor.newInstance(path);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    protected Local create(Local parent, String path) {
        String clazz = PreferencesFactory.get().getProperty("factory.local.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{parent.getClass(), path.getClass()});
            return (Local)constructor.newInstance(parent, path);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static Local get(Local parent, String name) {
        return new LocalFactory().create(parent, name);
    }

    public static Local get(String parent, String name) {
        return new LocalFactory().create(new LocalFactory().create(parent), name);
    }

    public static Local get(String path) {
        return new LocalFactory().create(path);
    }
}

