/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class LoginCallbackFactory
extends Factory<LoginCallback> {
    private static final Logger log = Logger.getLogger(LoginCallbackFactory.class);

    protected LoginCallbackFactory() {
        super("factory.logincallback.class");
    }

    public LoginCallback create(Controller controller) {
        String clazz = PreferencesFactory.get().getProperty("factory.logincallback.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (LoginCallback)name.newInstance();
            }
            return (LoginCallback)constructor.newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledLoginCallback();
        }
    }

    public static LoginCallback get(Controller c) {
        return new LoginCallbackFactory().create(c);
    }
}

