/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Protocol;
import java.util.Objects;

public final class LoginOptions {
    public boolean user = true;
    public boolean password = true;
    public boolean keychain = true;
    public boolean publickey = false;
    public boolean anonymous = false;
    public String icon;

    public LoginOptions() {
    }

    public LoginOptions user(boolean e) {
        this.user = e;
        return this;
    }

    public LoginOptions password(boolean e) {
        this.password = e;
        return this;
    }

    public LoginOptions keychain(boolean e) {
        this.keychain = e;
        return this;
    }

    public LoginOptions publickey(boolean e) {
        this.publickey = e;
        return this;
    }

    public LoginOptions anonymous(boolean e) {
        this.anonymous = e;
        return this;
    }

    public LoginOptions icon(String icon) {
        this.icon = icon;
        return this;
    }

    public boolean user() {
        return this.user;
    }

    public boolean password() {
        return this.password;
    }

    public boolean keychain() {
        return this.keychain;
    }

    public boolean publickey() {
        return this.publickey;
    }

    public boolean anonymous() {
        return this.anonymous;
    }

    public String icon() {
        return this.icon;
    }

    public LoginOptions(Protocol protocol) {
        this.configure(protocol);
    }

    public void configure(Protocol protocol) {
        this.publickey = protocol.getType() == Protocol.Type.sftp;
        this.anonymous = protocol.isAnonymousConfigurable();
        this.user = protocol.isUsernameConfigurable();
        this.password = protocol.isPasswordConfigurable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginOptions that = (LoginOptions)o;
        return this.user == that.user && this.password == that.password && this.keychain == that.keychain && this.publickey == that.publickey && this.anonymous == that.anonymous && Objects.equals(this.icon, that.icon);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.password, this.keychain, this.publickey, this.anonymous, this.icon);
    }
}

