/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class PasswordCallbackFactory
extends Factory<PasswordCallback> {
    private static final Logger log = Logger.getLogger(PasswordCallbackFactory.class);

    protected PasswordCallbackFactory() {
        super("factory.passwordcallback.class");
    }

    public PasswordCallback create(Controller controller) {
        String clazz = PreferencesFactory.get().getProperty("factory.passwordcallback.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (PasswordCallback)name.newInstance();
            }
            return (PasswordCallback)constructor.newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledPasswordCallback();
        }
    }

    public static PasswordCallback get(Controller c) {
        return new PasswordCallbackFactory().create(c);
    }
}

