/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Serializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Permission
implements Serializable {
    public static final Permission EMPTY = new Permission(Action.none, Action.none, Action.none){

        @Override
        public boolean isExecutable() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public String toString() {
            return LocaleFactory.localizedString("--");
        }

        @Override
        public String getMode() {
            return LocaleFactory.localizedString("--");
        }

        @Override
        public String getSymbol() {
            return LocaleFactory.localizedString("--");
        }
    };
    private static final Logger log = Logger.getLogger(Permission.class);
    private Action user;
    private Action group;
    private Action other;
    private boolean setuid;
    private boolean setgid;
    private boolean sticky;

    public Permission() {
        this.set(Action.none, Action.none, Action.none, false, false, false);
    }

    public Permission(String mode) {
        try {
            this.fromInteger(Integer.parseInt(mode, 8));
        }
        catch (NumberFormatException e) {
            this.fromSymbol(mode);
        }
    }

    public Permission(Action u, Action g, Action o) {
        this.set(u, g, o, false, false, false);
    }

    public Permission(Action u, Action g, Action o, boolean stickybit, boolean setuid, boolean setgid) {
        this.set(u, g, o, stickybit, setuid, setgid);
    }

    public Permission(int mode) {
        try {
            this.fromInteger(Integer.valueOf(Integer.toString(mode), 8));
        }
        catch (NumberFormatException e) {
            log.warn((Object)String.format("Failure parsing %s", mode));
            this.set(EMPTY);
        }
    }

    public Permission(Permission other) {
        this.set(other.user, other.group, other.other, other.sticky, other.setuid, other.setgid);
    }

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(this.getSymbol(), "Mask");
        return dict.getSerialized();
    }

    private void set(Permission other) {
        this.set(other.user, other.group, other.other, other.sticky, other.setuid, other.setgid);
    }

    private void set(Action u, Action g, Action o, boolean s, boolean setuid, boolean setgid) {
        this.user = u;
        this.group = g;
        this.other = o;
        this.sticky = s;
        this.setuid = setuid;
        this.setgid = setgid;
    }

    private void fromInteger(int n) {
        Action[] v = Action.values();
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7], (n >>> 9 & 1) == 1, (n >>> 9 & 4) == 4, (n >>> 9 & 2) == 2);
    }

    private int toInteger() {
        return (this.sticky ? 512 : 0) | (this.setuid ? 2048 : 0) | (this.setgid ? 1024 : 0) | this.user.ordinal() << 6 | this.group.ordinal() << 3 | this.other.ordinal();
    }

    private void fromSymbol(String symbol) {
        try {
            int n = 0;
            for (int i = 0; i < symbol.length(); ++i) {
                n <<= 1;
                char c = symbol.charAt(i);
                n += c == '-' || c == 'T' || c == 'S' ? 0 : 1;
            }
            if (symbol.charAt(8) == 't' || symbol.charAt(8) == 'T') {
                n += 512;
            }
            if (symbol.charAt(5) == 's' || symbol.charAt(5) == 'S') {
                n += 1024;
            }
            if (symbol.charAt(2) == 's' || symbol.charAt(2) == 'S') {
                n += 2048;
            }
            this.fromInteger(n);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warn((Object)String.format("Failure parsing %s", symbol));
            this.set(EMPTY);
        }
    }

    public Action getUser() {
        return this.user;
    }

    public void setUser(Action user) {
        this.user = user;
    }

    public Action getGroup() {
        return this.group;
    }

    public void setGroup(Action group) {
        this.group = group;
    }

    public Action getOther() {
        return this.other;
    }

    public void setOther(Action other) {
        this.other = other;
    }

    public boolean isSetuid() {
        return this.setuid;
    }

    public void setSetuid(boolean setuid) {
        this.setuid = setuid;
    }

    public boolean isSetgid() {
        return this.setgid;
    }

    public void setSetgid(boolean setgid) {
        this.setgid = setgid;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public String getSymbol() {
        StringBuilder symbolic = new StringBuilder();
        symbolic.append(this.setuid ? (this.user.implies(Action.execute) ? StringUtils.substring((String)this.user.symbolic, (int)0, (int)2) + "s" : StringUtils.substring((String)this.user.symbolic, (int)0, (int)2) + "S") : this.user.symbolic);
        symbolic.append(this.setgid ? (this.group.implies(Action.execute) ? StringUtils.substring((String)this.group.symbolic, (int)0, (int)2) + "s" : StringUtils.substring((String)this.group.symbolic, (int)0, (int)2) + "S") : this.group.symbolic);
        symbolic.append(this.sticky ? (this.other.implies(Action.execute) ? StringUtils.substring((String)this.other.symbolic, (int)0, (int)2) + "t" : StringUtils.substring((String)this.other.symbolic, (int)0, (int)2) + "T") : this.other.symbolic);
        return symbolic.toString();
    }

    public String getMode() {
        return Integer.toString(this.toInteger(), 8);
    }

    public String toString() {
        return String.format("%s (%s)", this.getSymbol(), this.getMode());
    }

    public boolean isExecutable() {
        return this.getUser().implies(Action.execute) || this.getGroup().implies(Action.execute) || this.getOther().implies(Action.execute);
    }

    public boolean isReadable() {
        return this.getUser().implies(Action.read) || this.getGroup().implies(Action.read) || this.getOther().implies(Action.read);
    }

    public boolean isWritable() {
        return this.getUser().implies(Action.write) || this.getGroup().implies(Action.write) || this.getOther().implies(Action.write);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        if (this.setgid != that.setgid) {
            return false;
        }
        if (this.setuid != that.setuid) {
            return false;
        }
        if (this.sticky != that.sticky) {
            return false;
        }
        if (this.group != that.group) {
            return false;
        }
        if (this.other != that.other) {
            return false;
        }
        return this.user == that.user;
    }

    public int hashCode() {
        return this.toInteger();
    }

    public static enum Action {
        none("---"),
        execute("--x"),
        write("-w-"),
        write_execute("-wx"),
        read("r--"),
        read_execute("r-x"),
        read_write("rw-"),
        all("rwx");

        private static final Action[] values;
        public final String symbolic;

        private Action(String symbol) {
            this.symbolic = symbol;
        }

        public boolean implies(Action that) {
            if (that != null) {
                return (this.ordinal() & that.ordinal()) == that.ordinal();
            }
            return false;
        }

        public Action and(Action that) {
            return values[this.ordinal() & that.ordinal()];
        }

        public Action or(Action that) {
            return values[this.ordinal() | that.ordinal()];
        }

        public Action not() {
            return values[7 - this.ordinal()];
        }

        static {
            values = Action.values();
        }
    }
}

