/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Profile
implements Protocol,
Serializable {
    private static final Logger log = Logger.getLogger(Profile.class);
    private final Deserializer<String> dict;
    private final Protocol parent;
    private final Local image;

    public Profile(Protocol parent, Deserializer<String> dict) {
        this.parent = parent;
        this.dict = dict;
        this.image = this.write(this.value("Disk"));
    }

    @Override
    public <T> T serialize(Serializer dict) {
        throw new UnsupportedOperationException();
    }

    public Protocol getProtocol() {
        return this.parent;
    }

    @Override
    public String getPrefix() {
        return this.parent.getPrefix();
    }

    @Override
    public boolean isEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.value("Protocol")) && StringUtils.isNotBlank((CharSequence)this.value("Vendor"));
    }

    @Override
    public boolean isSecure() {
        return this.getScheme().isSecure();
    }

    @Override
    public String getIdentifier() {
        return this.parent.getIdentifier();
    }

    @Override
    public Protocol.Type getType() {
        return this.parent.getType();
    }

    @Override
    public String getUsernamePlaceholder() {
        String v = this.value("Username Placeholder");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getUsernamePlaceholder();
        }
        return v;
    }

    @Override
    public String getPasswordPlaceholder() {
        String v = this.value("Password Placeholder");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getPasswordPlaceholder();
        }
        return v;
    }

    @Override
    public String getDefaultHostname() {
        String v = this.value("Default Hostname");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultHostname();
        }
        return v;
    }

    @Override
    public String getProvider() {
        String v = this.value("Vendor");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getProvider();
        }
        return v;
    }

    @Override
    public String getName() {
        String v = this.value("Name");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getName();
        }
        return v;
    }

    @Override
    public String getDescription() {
        String v = this.value("Description");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDescription();
        }
        return v;
    }

    @Override
    public int getDefaultPort() {
        String v = this.value("Default Port");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getDefaultPort();
        }
        try {
            return Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            log.warn((Object)String.format("Port %s is not a number", e.getMessage()));
            return this.parent.getDefaultPort();
        }
    }

    @Override
    public String getRegion() {
        String v = this.value("Region");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getRegion();
        }
        return v;
    }

    @Override
    public String disk() {
        if (null == this.image) {
            return this.parent.disk();
        }
        return this.image.getAbsolute();
    }

    @Override
    public String icon() {
        if (null == this.image) {
            return this.parent.icon();
        }
        return this.image.getAbsolute();
    }

    @Override
    public String favicon() {
        return this.parent.favicon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Local write(String icon) {
        if (StringUtils.isBlank((CharSequence)icon)) {
            return null;
        }
        byte[] favicon = Base64.decodeBase64((String)icon);
        Local file = TemporaryFileServiceFactory.get().create(String.format("%s.ico", new AlphanumericRandomStringService().random()));
        try {
            new DefaultLocalTouchFeature().touch(file);
            OutputStream out = file.getOutputStream(false);
            try {
                IOUtils.write((byte[])favicon, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return file;
        }
        catch (AccessDeniedException | IOException e) {
            log.error((Object)"Error writing temporary file", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean validate(Credentials credentials, LoginOptions options) {
        return this.parent.validate(credentials, options);
    }

    @Override
    public Scheme getScheme() {
        String v = this.value("Scheme");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getScheme();
        }
        return Scheme.valueOf(v);
    }

    @Override
    public String[] getSchemes() {
        return this.parent.getSchemes();
    }

    @Override
    public String getContext() {
        String v = this.value("Context");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getContext();
        }
        return v;
    }

    @Override
    public String getAuthorization() {
        String v = this.value("Authorization");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getAuthorization();
        }
        return v;
    }

    @Override
    public String getOAuthAuthorizationUrl() {
        String v = this.value("OAuth Authorization Url");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthAuthorizationUrl();
        }
        return v;
    }

    @Override
    public String getOAuthTokenUrl() {
        String v = this.value("OAuth Token Url");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getOAuthAuthorizationUrl();
        }
        return v;
    }

    @Override
    public List<String> getScopes() {
        return this.list("Scopes");
    }

    @Override
    public Set<Location.Name> getRegions() {
        List<String> regions = this.list("Regions");
        HashSet<Location.Name> set = new HashSet<Location.Name>();
        for (String region : regions) {
            set.add(new Location.Name(region));
        }
        return set;
    }

    @Override
    public boolean isEncodingConfigurable() {
        return this.parent.isEncodingConfigurable();
    }

    @Override
    public boolean isAnonymousConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Anonymous Configurable"))) {
            return this.parent.isAnonymousConfigurable();
        }
        return this.bool("Anonymous Configurable");
    }

    @Override
    public boolean isUsernameConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Username Configurable"))) {
            return this.parent.isUsernameConfigurable();
        }
        return this.bool("Username Configurable");
    }

    @Override
    public boolean isPasswordConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Password Configurable"))) {
            return this.parent.isPasswordConfigurable();
        }
        return this.bool("Password Configurable");
    }

    @Override
    public boolean isHostnameConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Hostname Configurable"))) {
            return this.parent.isHostnameConfigurable();
        }
        return this.bool("Hostname Configurable");
    }

    @Override
    public boolean isPortConfigurable() {
        if (StringUtils.isBlank((CharSequence)this.value("Port Configurable"))) {
            return this.parent.isPortConfigurable();
        }
        return this.bool("Port Configurable");
    }

    @Override
    public String getClientId() {
        String v = this.value("OAuth Client ID");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getClientId();
        }
        return v;
    }

    @Override
    public String getClientSecret() {
        String v = this.value("OAuth Client Secret");
        if (StringUtils.isBlank((CharSequence)v)) {
            return this.parent.getClientSecret();
        }
        return v;
    }

    @Override
    public boolean isUTCTimezone() {
        return this.parent.isUTCTimezone();
    }

    private String value(String key) {
        return this.dict.stringForKey(key);
    }

    private List<String> list(String key) {
        List<String> list = this.dict.listForKey(key);
        if (null == list) {
            return Collections.emptyList();
        }
        return list;
    }

    private boolean bool(String key) {
        return this.dict.booleanForKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(protocol.getIdentifier()) : protocol.getIdentifier() != null) {
            return false;
        }
        if (this.getScheme() != null ? !this.getScheme().equals((Object)protocol.getScheme()) : protocol.getScheme() != null) {
            return false;
        }
        if (this.getContext() != null ? !this.getContext().equals(protocol.getContext()) : protocol.getContext() != null) {
            return false;
        }
        if (this.getAuthorization() != null ? !this.getAuthorization().equals(protocol.getAuthorization()) : protocol.getAuthorization() != null) {
            return false;
        }
        if (this.getProvider() != null ? !this.getProvider().equals(protocol.getProvider()) : protocol.getProvider() != null) {
            return false;
        }
        return !(this.getDefaultHostname() != null ? !this.getDefaultHostname().equals(protocol.getDefaultHostname()) : protocol.getDefaultHostname() != null);
    }

    public int hashCode() {
        int result = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result = 31 * result + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        result = 31 * result + (this.getContext() != null ? this.getContext().hashCode() : 0);
        result = 31 * result + (this.getAuthorization() != null ? this.getAuthorization().hashCode() : 0);
        result = 31 * result + (this.getProvider() != null ? this.getProvider().hashCode() : 0);
        result = 31 * result + (this.getDefaultHostname() != null ? this.getDefaultHostname().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Protocol o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Profile{");
        sb.append("parent=").append(this.parent);
        sb.append(", image=").append(this.image);
        sb.append('}');
        return sb.toString();
    }
}

