/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.features.Location;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public interface Protocol
extends Comparable<Protocol> {
    public boolean validate(Credentials var1, LoginOptions var2);

    public boolean isAnonymousConfigurable();

    public boolean isUsernameConfigurable();

    public boolean isPasswordConfigurable();

    public boolean isHostnameConfigurable();

    public boolean isPortConfigurable();

    public boolean isEncodingConfigurable();

    public boolean isUTCTimezone();

    public String getName();

    public boolean isEnabled();

    public boolean isSecure();

    public String getProvider();

    public Type getType();

    public String getIdentifier();

    public String getPrefix();

    public String getDescription();

    public Scheme getScheme();

    public String[] getSchemes();

    public String getDefaultHostname();

    public int getDefaultPort();

    public String getContext();

    public String getAuthorization();

    public String getOAuthAuthorizationUrl();

    public String getOAuthTokenUrl();

    public List<String> getScopes();

    public Set<Location.Name> getRegions();

    public String getRegion();

    public String disk();

    public String icon();

    public String favicon();

    public String getUsernamePlaceholder();

    public String getPasswordPlaceholder();

    public String getClientId();

    public String getClientSecret();

    public static enum Type {
        ftp{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                if (options.user && StringUtils.isBlank((CharSequence)credentials.getUsername())) {
                    return false;
                }
                if (options.password) {
                    return credentials.getPassword() != null;
                }
                return true;
            }
        }
        ,
        sftp{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                if (options.user) {
                    return StringUtils.isNotBlank((CharSequence)credentials.getUsername());
                }
                return true;
            }
        }
        ,
        s3,
        googlestorage{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                return true;
            }
        }
        ,
        dropbox,
        googledrive{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                return true;
            }
        }
        ,
        swift,
        dav,
        azure{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                return super.validate(credentials, options) && Base64.isBase64((String)credentials.getPassword());
            }
        }
        ,
        onedrive{

            @Override
            public boolean validate(Credentials credentials, LoginOptions options) {
                return true;
            }
        }
        ,
        irods,
        b2,
        file;


        public boolean validate(Credentials credentials, LoginOptions options) {
            if (options.user && StringUtils.isBlank((CharSequence)credentials.getUsername())) {
                return false;
            }
            return !options.password || !StringUtils.isEmpty((CharSequence)credentials.getPassword());
        }
    }
}

