/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.ProfileReaderFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class ProtocolFactory {
    private static final Logger log = Logger.getLogger(ProtocolFactory.class);
    private static final Set<Protocol> registered = new LinkedHashSet<Protocol>();
    public static final ProtocolFactory global = new ProtocolFactory(registered);
    private final Set<Protocol> protocols;

    public ProtocolFactory(Set<Protocol> protocols) {
        this.protocols = protocols;
    }

    public Protocol find(String identifier) {
        return ProtocolFactory.forName(this.protocols, identifier);
    }

    public static void register(Protocol ... protocols) {
        Local library;
        for (Protocol protocol : protocols) {
            ProtocolFactory.register(protocol);
        }
        Local bundled = LocalFactory.get(PreferencesFactory.get().getProperty("application.profiles.path"));
        if (bundled.exists()) {
            try {
                for (Local f : bundled.list().filter(new ProfileFilter())) {
                    Profile profile = ProfileReaderFactory.get().read(f);
                    if (null == profile.getProtocol()) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Adding bundled protocol %s", profile));
                    }
                    ProtocolFactory.register((Protocol)profile);
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading collection %s %s", bundled, e.getMessage()));
            }
        }
        if ((library = LocalFactory.get(PreferencesFactory.get().getProperty("application.support.path"), PreferencesFactory.get().getProperty("profiles.folder.name"))).exists()) {
            try {
                for (Local local : library.list().filter(new ProfileFilter())) {
                    Profile protocol = ProfileReaderFactory.get().read(local);
                    if (null == protocol) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Adding thirdparty protocol %s", protocol));
                    }
                    ProtocolFactory.register((Protocol)protocol);
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading collection %s %s", library, e.getMessage()));
            }
        }
    }

    public static void register(Protocol p) {
        registered.remove(p);
        registered.add(p);
    }

    public static List<Protocol> getEnabledProtocols() {
        ArrayList<Protocol> enabled = new ArrayList<Protocol>();
        for (Protocol protocol : registered) {
            if (!protocol.isEnabled()) continue;
            enabled.add(protocol);
        }
        return enabled;
    }

    public static Protocol forName(String identifier) {
        return ProtocolFactory.forName(registered, identifier);
    }

    public static Protocol forName(Set<Protocol> protocols, String identifier) {
        for (Protocol protocol : protocols) {
            if (!protocol.getProvider().equals(identifier)) continue;
            return protocol;
        }
        for (Protocol protocol : protocols) {
            if (!String.valueOf(protocol.hashCode()).equals(identifier)) continue;
            return protocol;
        }
        for (Protocol protocol : protocols) {
            for (String scheme : protocol.getSchemes()) {
                if (!scheme.equals(identifier)) continue;
                return protocol;
            }
        }
        log.warn((Object)String.format("Unknown protocol with identifier %s", identifier));
        return null;
    }

    public static Protocol forScheme(String scheme) {
        return ProtocolFactory.forScheme(registered, scheme);
    }

    public static Protocol forScheme(Set<Protocol> protocols, String scheme) {
        for (Protocol protocol : protocols) {
            for (int k = 0; k < protocol.getSchemes().length; ++k) {
                if (!protocol.getSchemes()[k].equals(scheme)) continue;
                return protocol;
            }
        }
        log.warn((Object)String.format("Unknown scheme %s", scheme));
        return null;
    }

    private static class ProfileFilter
    implements Filter<Local> {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "cyberduckprofile".equals(FilenameUtils.getExtension((String)file.getName()));
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberduckprofile");
        }
    }
}

