/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class TransferErrorCallbackControllerFactory
extends Factory<TransferErrorCallback> {
    private static final Logger log = Logger.getLogger(TransferErrorCallbackControllerFactory.class);
    private static final Preferences preferences = PreferencesFactory.get();

    public TransferErrorCallback create(Controller c) {
        String clazz = preferences.getProperty("factory.transfererrorcallback.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{c.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", c.getClass()));
                return (TransferErrorCallback)name.newInstance();
            }
            return (TransferErrorCallback)constructor.newInstance(c);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledTransferErrorCallback();
        }
    }

    public static TransferErrorCallback get(Controller c) {
        return new TransferErrorCallbackControllerFactory().create(c);
    }
}

