/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class URIEncoder {
    private URIEncoder() {
    }

    public static String encode(String p) {
        try {
            StringBuilder b = new StringBuilder();
            StringTokenizer t = new StringTokenizer(p, "/");
            if (!t.hasMoreTokens()) {
                return p;
            }
            if (StringUtils.startsWith((CharSequence)p, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            while (t.hasMoreTokens()) {
                b.append(URLEncoder.encode(t.nextToken(), "UTF-8"));
                if (!t.hasMoreTokens()) continue;
                b.append('/');
            }
            if (StringUtils.endsWith((CharSequence)p, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            return b.toString().replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return p;
        }
    }
}

