/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import java.net.URI;
import java.text.MessageFormat;

public class WebUrlProvider
implements UrlProvider {
    private final Host host;

    public WebUrlProvider(Host host) {
        this.host = host;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        list.add(new DescriptiveUrl(URI.create(String.format("%s/%s", this.host.getWebURL(), URIEncoder.encode(PathRelativizer.relativize(PathNormalizer.normalize(this.host.getDefaultPath(), true), file.getAbsolute())))).normalize(), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), "HTTP")));
        return list;
    }
}

