/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.aquaticprime.AbstractLicense;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.text.NaturalOrderComparator;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class DonationKey
extends AbstractLicense
implements LicenseVerifier {
    private static final Logger log = Logger.getLogger(DonationKey.class);
    private static final String pub = "0xAF026CFCF552C3D09A051124A596CEF7BBB26B15629504CD163B09675BE507C9C526ED3DBFCB91B78F718E0886A18400B56BC00E9213228CD6D6E9C84D8B6099AA3DE6E6F46F6CC7970982DE93A2A7318351FDFA25AE75B403996E50BB40643384214234E84EDA3E518772A4FF57FE29DD7C77A5EEB14C9023CA18FEC63236EF";
    private final Local file;
    private final NSDictionary dictionary;

    public DonationKey(Local file) {
        super(file);
        this.file = file;
        this.dictionary = this.read();
    }

    @Override
    public boolean verify() {
        boolean valid;
        if (null == this.dictionary) {
            return false;
        }
        NSData signature = (NSData)this.dictionary.objectForKey("Signature");
        if (null == signature) {
            log.warn((Object)String.format("Missing key 'Signature' in dictionary %s", this.dictionary));
            return false;
        }
        StringBuilder values = new StringBuilder();
        ArrayList keys = new ArrayList(this.dictionary.keySet());
        Collections.sort(keys, new NaturalOrderComparator());
        for (String key : keys) {
            if ("Signature".equals(key)) continue;
            values.append(this.dictionary.objectForKey(key).toString());
        }
        byte[] signaturebytes = signature.bytes();
        byte[] plainbytes = values.toString().getBytes(Charset.forName("UTF-8"));
        try {
            BigInteger modulus = new BigInteger(StringUtils.removeStart((String)this.getPublicKey(), (String)"0x"), 16);
            BigInteger exponent = new BigInteger(Base64.decodeBase64((String)"Aw=="));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            PublicKey rsa = KeyFactory.getInstance("RSA").generatePublic(spec);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(2, rsa);
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA1");
            valid = Arrays.equals(rsaCipher.doFinal(signaturebytes), sha1Digest.digest(plainbytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.warn((Object)String.format("Signature verification failure for key %s", this.file));
            return false;
        }
        if (valid) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Valid key in %s", this.file));
            }
        } else {
            log.warn((Object)String.format("Not a valid key in %s", this.file));
        }
        return valid;
    }

    @Override
    public String getValue(String property) {
        if (null == this.dictionary) {
            return null;
        }
        NSObject value = this.dictionary.objectForKey(property);
        if (null == value) {
            log.warn((Object)String.format("No value for key %s in dictionary %s", property, this.dictionary));
            return null;
        }
        return value.toString();
    }

    protected String getPublicKey() {
        return pub;
    }

    private NSDictionary read() {
        try {
            return (NSDictionary)XMLPropertyListParser.parse((InputStream)this.file.getInputStream());
        }
        catch (AccessDeniedException | PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            log.warn((Object)String.format("Failure %s reading dictionary from %s", e.getMessage(), this.file));
            return null;
        }
    }
}

