/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.http.DisabledX509HostnameVerifier;
import ch.cyberduck.core.http.ExtendedHttpRequestRetryHandler;
import ch.cyberduck.core.http.LoggingHttpRequestExecutor;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.net.SocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.log4j.Logger;

public class HttpConnectionPoolBuilder {
    private static final Logger log = Logger.getLogger(HttpConnectionPoolBuilder.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final ConnectionSocketFactory socketFactory;
    private final ConnectionSocketFactory sslSocketFactory;
    private final ProxyFinder proxyFinder;
    private final Host host;

    public HttpConnectionPoolBuilder(final Host host, final ThreadLocalHostnameDelegatingTrustManager trust, X509KeyManager key, final ProxyFinder proxy) {
        this(host, (ConnectionSocketFactory)new PlainConnectionSocketFactory(){

            public Socket createSocket(final HttpContext context) throws IOException {
                return new ProxySocketFactory(host.getProtocol(), new TrustManagerHostnameCallback(){

                    @Override
                    public String getTarget() {
                        return context.getAttribute("http.target_host").toString();
                    }
                }, proxy).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }
        }, (ConnectionSocketFactory)new SSLConnectionSocketFactory(new CustomTrustSSLProtocolSocketFactory(trust, key), new DisabledX509HostnameVerifier()){

            public Socket createSocket(final HttpContext context) throws IOException {
                return new ProxySocketFactory(host.getProtocol(), new TrustManagerHostnameCallback(){

                    @Override
                    public String getTarget() {
                        return context.getAttribute("http.target_host").toString();
                    }
                }, proxy).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host2, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                trust.setTarget(remoteAddress.getHostName());
                return super.connectSocket(connectTimeout, socket, host2, remoteAddress, localAddress, context);
            }
        }, proxy);
    }

    protected HttpConnectionPoolBuilder(Host host, final X509TrustManager trust, X509KeyManager key, ProxyFinder proxy, final SocketFactory socketFactory) {
        this(host, (ConnectionSocketFactory)new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) throws IOException {
                return socketFactory.createSocket();
            }
        }, (ConnectionSocketFactory)new SSLConnectionSocketFactory(new CustomTrustSSLProtocolSocketFactory(trust, key), new DisabledX509HostnameVerifier()){

            public Socket createSocket(HttpContext context) throws IOException {
                return socketFactory.createSocket();
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                if (trust instanceof ThreadLocalHostnameDelegatingTrustManager) {
                    ((ThreadLocalHostnameDelegatingTrustManager)trust).setTarget(remoteAddress.getHostName());
                }
                return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
            }
        }, proxy);
    }

    public HttpConnectionPoolBuilder(Host host, ConnectionSocketFactory socketFactory, ConnectionSocketFactory sslSocketFactory, ProxyFinder proxyFinder) {
        this.host = host;
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.proxyFinder = proxyFinder;
    }

    public HttpClientBuilder build(TranscriptListener listener) {
        HttpHost h;
        HttpClientBuilder configuration = HttpClients.custom();
        Proxy proxy = this.proxyFinder.find(this.host);
        if (proxy.getType() == Proxy.Type.HTTP) {
            h = new HttpHost(proxy.getHostname(), proxy.getPort(), Scheme.http.name());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Setup proxy %s", h));
            }
            configuration.setProxy(h);
        }
        if (proxy.getType() == Proxy.Type.HTTPS) {
            h = new HttpHost(proxy.getHostname(), proxy.getPort(), Scheme.https.name());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Setup proxy %s", h));
            }
            configuration.setProxy(h);
        }
        configuration.setUserAgent(new PreferencesUseragentProvider().get());
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        configuration.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(timeout).build());
        configuration.setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(true).setExpectContinueEnabled(false).setAuthenticationEnabled(true).setConnectTimeout(timeout).setConnectionRequestTimeout(this.preferences.getInteger("http.manager.timeout")).setSocketTimeout(timeout).build());
        String encoding = null == this.host.getEncoding() ? this.preferences.getProperty("browser.charset.encoding") : this.host.getEncoding();
        configuration.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(this.preferences.getInteger("http.socket.buffer")).setCharset(Charset.forName(encoding)).build());
        if (this.preferences.getBoolean("http.connections.reuse")) {
            configuration.setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultClientConnectionReuseStrategy());
        } else {
            configuration.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        configuration.setRetryHandler((HttpRequestRetryHandler)new ExtendedHttpRequestRetryHandler(this.preferences.getInteger("http.connections.retry")));
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DisabledServiceUnavailableRetryStrategy());
        if (!this.preferences.getBoolean("http.compression.enable")) {
            configuration.disableContentCompression();
        }
        configuration.setRequestExecutor((HttpRequestExecutor)new LoggingHttpRequestExecutor(listener));
        configuration.setConnectionManager((HttpClientConnectionManager)this.pool((Registry<ConnectionSocketFactory>)this.registry().build()));
        configuration.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(Charset.forName(this.preferences.getProperty("http.credentials.charset")))).register("Digest", (Object)new DigestSchemeFactory(Charset.forName(this.preferences.getProperty("http.credentials.charset")))).register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).build());
        return configuration;
    }

    protected RegistryBuilder<ConnectionSocketFactory> registry() {
        return RegistryBuilder.create().register(Scheme.http.toString(), (Object)this.socketFactory).register(Scheme.https.toString(), (Object)this.sslSocketFactory);
    }

    protected PoolingHttpClientConnectionManager pool(Registry<ConnectionSocketFactory> registry) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Setup connection pool with registry %s", registry));
        }
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(this.preferences.getInteger("http.connections.total"));
        manager.setDefaultMaxPerRoute(this.preferences.getInteger("http.connections.route"));
        manager.setValidateAfterInactivity(5000);
        return manager;
    }
}

