/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import org.apache.http.client.HttpResponseException;

public class HttpResponseExceptionMappingService
extends AbstractExceptionMappingService<HttpResponseException> {
    @Override
    public BackgroundException map(HttpResponseException failure) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, failure.getMessage());
        int statusCode = failure.getStatusCode();
        switch (statusCode) {
            case 401: {
                return new LoginFailureException(buffer.toString(), (Throwable)failure);
            }
            case 403: {
                return new AccessDeniedException(buffer.toString(), (Throwable)failure);
            }
            case 409: {
                return new ConflictException(buffer.toString(), (Throwable)failure);
            }
            case 404: 
            case 410: {
                return new NotfoundException(buffer.toString(), (Throwable)failure);
            }
            case 402: 
            case 419: 
            case 507: {
                return new QuotaException(buffer.toString(), (Throwable)failure);
            }
            case 400: 
            case 405: 
            case 422: 
            case 500: 
            case 501: {
                return new InteroperabilityException(buffer.toString(), (Throwable)failure);
            }
            case 408: {
                return new ConnectionTimeoutException(buffer.toString(), (Throwable)failure);
            }
            case 429: 
            case 503: 
            case 509: {
                return new RetriableAccessDeniedException(buffer.toString(), (Throwable)failure);
            }
        }
        return this.wrap(failure, buffer);
    }
}

