/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UseragentProvider;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class LoggingHttpRequestExecutor
extends HttpRequestExecutor {
    private final UseragentProvider useragentProvider = new PreferencesUseragentProvider();
    private final TranscriptListener listener;

    public LoggingHttpRequestExecutor(TranscriptListener listener) {
        this.listener = listener;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        if (!request.containsHeader("User-Agent")) {
            request.addHeader((Header)new BasicHeader("User-Agent", this.useragentProvider.get()));
        }
        return super.execute(request, conn, context);
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        this.listener.log(TranscriptListener.Type.request, request.getRequestLine().toString());
        block8: for (Header header : request.getAllHeaders()) {
            switch (header.getName()) {
                case "Authorization": 
                case "X-Auth-Key": 
                case "X-Auth-Token": {
                    this.listener.log(TranscriptListener.Type.request, String.format("%s: %s", header.getName(), StringUtils.repeat((String)"*", (int)Integer.min(8, StringUtils.length((CharSequence)header.getValue())))));
                    continue block8;
                }
                default: {
                    this.listener.log(TranscriptListener.Type.request, header.toString());
                }
            }
        }
        return super.doSendRequest(request, conn, context);
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        HttpResponse response = super.doReceiveResponse(request, conn, context);
        this.listener.log(TranscriptListener.Type.response, response.getStatusLine().toString());
        for (Header header : response.getAllHeaders()) {
            this.listener.log(TranscriptListener.Type.response, header.toString());
        }
        return response;
    }
}

